/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR REPRESENTATIONS,
 * EITHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY
 * OR COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. TI DISCLAIMS
 * ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET POSSESSION, AND NON-INFRINGEMENT
 * OF ANY THIRD PARTY INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
 * YOUR USE OF THE PROGRAM.
 * IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL OR
 * INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY THEORY OF LIABILITY AND WHETHER OR
 * NOT TI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY
 * OUT OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.  EXCLUDED
 * DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF REMOVAL OR REINSTALLATION,
 * COMPUTER TIME, LABOR COSTS, LOSS OF GOODWILL, LOSS OF PROFITS, LOSS OF
 * SAVINGS, OR LOSS OF USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
 * AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF YOUR USE OF THE
 * PROGRAM EXCEED FIVE HUNDRED DOLLARS (U.S.$500).
 * Unless otherwise stated, the Program written and copyrighted by Texas
 * Instruments is distributed as "freeware".  You may, only under TI's copyright
 * in the Program, use and modify the Program without any charge or restriction.
 * You may distribute to third parties, provided that you transfer a copy of this
 * license to the third party and the third party agrees to these terms by its
 * first use of the Program. You must reproduce the copyright notice and any
 * other legend of ownership on each copy or partial copy, of the Program.
 * You acknowledge and agree that the Program contains copyrighted material,
 * trade secrets and other TI proprietary information and is protected by
 * copyright laws, international copyright treaties, and trade secret laws, as
 * well as other intellectual property laws.  To protect TI's rights in the
 * Program, you agree not to decompile, reverse engineer, disassemble or
 * otherwise translate any object code versions of the Program to a
 * human-readable form.  You agree that in no event will you alter, remove or
 * destroy any copyright notice included in the Program.  TI reserves all rights
 * not specifically granted under this license. Except as specifically provided
 * herein, nothing in this agreement shall be construed as conferring by
 * implication, estoppel, or otherwise, upon you, any license or other right
 * under any TI patents, copyrights or trade secrets.
 * You may not use the Program in non-TI devices. */


//******************************************************************************
//
//  timerB.c
//  Initialization and control of timerB
//	timerB is used to generate the synchronization signals (175/350 kHz)
//
//  Design Services - EMEA Power Management
//  Texas Instruments, Inc.
//
//******************************************************************************


#include "main.h"



static volatile unsigned int counter_26u = 0;	// used for 26us interrupt
static volatile unsigned int Fan_counter = 0;	// used for measuring Fan speed



// initialization of Timer_B for PWM
// main and bias synchronization
void init_timerB(void)
{
	// reset Timer_B
  	set_bit(TBCTL, TBCLR);
  	
  	// no grouping of TBCL0 and TBCL1, each is independent
  	clear_bit(TBCTL, TBCLGRP1);
  	clear_bit(TBCTL, TBCLGRP0);
	
	// counter length set to 16 bit, max = 0xFFFF
	clear_bit(TBCTL, CNTL1);
	clear_bit(TBCTL, CNTL0);
	
	// SMCLK as source for Timer_B
	set_bit(TBCTL, TBSSEL1);
	clear_bit(TBCTL, TBSSEL0);
	
	// input divider 1 -> counter is running @ 16MHz
	clear_bit(TBCTL, ID1);
	clear_bit(TBCTL, ID0);
	
	// timer in up mode
	clear_bit(TBCTL, MC1);
	set_bit(TBCTL, MC0);
	
	// TACCR0 = 416 ==> 16MHz / 416 = 38460 Hz
	TBCCR0 = 416;		//
	TBCCR1 = 100;	//
	
	// no capture
//	clear_bit(TBCCTL2, CM1);
//	clear_bit(TBCCTL2, CM0);
	clear_bit(TBCCTL1, CM1);
	clear_bit(TBCCTL1, CM0);
	
	// set compare mode
//	clear_bit(TBCCTL2, CAP);
	clear_bit(TBCCTL1, CAP);
	
	// output mode: pins are controlled by timer_B, "Reset/Set mode"

//	TBCCTL2 = OUTMOD_7;
	TBCCTL1 = OUTMOD_7;
	
	// enable compare interrupt
	set_bit(TBCCTL0, CCIE);
	clear_bit(TBCCTL1, CCIE);
	
	// clear timer output function
	clear_bit(TB1_PSEL, TB1_BIT);
//	clear_bit(TB2_PSEL, TB2_BIT);
	
	// set pins as output
	set_bit(TB1_PDIR, TB1_BIT);
//	set_bit(TB2_PDIR, TB2_BIT);
	
	// set outputs high
	set_bit(TB1_POUT, TB1_BIT);
//	set_bit(TB2_POUT, TB2_BIT);
}



// executed every 26uus
#pragma vector = TIMERB0_VECTOR
__interrupt void TIMERB0_ISR(void)
{
	counter_26u++;     // increase counter

	if(fan_PIN & fan_BIT)
		{
			if (Fan_counter < 800) Fan_counter++;
		}
	else
		{
			if (Fan_counter > 0)
			{
				Fan_speed = Fan_counter;
				Fan_counter = 0;
			}
		}

	if(counter_26u > 38)
	{
		counter_26u = 0;
		flag_1ms = 1;
	}
}
